/*
 * Decompiled with CFR 0.152.
 */
package skeletonapplet;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import skeletonapplet.JreDatum;
import skeletonapplet.PtsiApplet;
import skeletonapplet.Utilities;

public class PtsiPreviewApplet
extends PtsiApplet {
    public static final Map DEFAULTS = PtsiPreviewApplet.initializeDefaults();

    public void init() {
        super.init();
        this.initialize();
    }

    public String getParameter(String string) {
        String string2 = super.getParameter(string);
        if (string2 != null && string2.trim().length() > 0) {
            return string2;
        }
        return (String)DEFAULTS.get(string);
    }

    protected void doInitialize() {
        this.prepareWorker(true);
    }

    protected void handleError(String string, String string2, String string3) {
        Utilities.logPrintln("handleError()");
        Utilities.logPrintln("\t\tadditionalUrlString = " + string);
        Utilities.logPrintln("\t\temergencyMessage = " + string2);
        Utilities.logPrintln("\t\temergencyId = " + string3);
        Utilities.warn("Error", string3 + ":  " + string2);
        Utilities.saveBuffer();
        Utilities.logPrintln("\n==> void");
    }

    protected void internalInstantiateWorker() throws Exception {
        block45: {
            Object object;
            Object object2;
            int n = this.getParameter("numberofdownloadtries", 5);
            String string = this.getParameter("patchjar");
            String string2 = this.getParameter("ptsajar");
            String string3 = this.getParameter("skeletonjar");
            File file = Utilities.getTemporaryDirectory();
            String string4 = this.getParameter("workerclass");
            Utilities.logPrintln("... numberofdownloadtries = " + n);
            Utilities.logPrintln("... patchJarName = " + string);
            Utilities.logPrintln("... ptsaJarName = " + string2);
            Utilities.logPrintln("... skeletonJarName = " + string3);
            Utilities.logPrintln("... workDirectory = " + file);
            Utilities.logPrintln("... workerName = " + string4);
            boolean bl = false;
            boolean bl2 = true;
            boolean bl3 = true;
            String string5 = null;
            String string6 = null;
            File file2 = null;
            File file3 = null;
            JarFile jarFile = null;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Object var16_16 = null;
            URL uRL = this.getDocumentBase();
            try {
                if (this.checkJre()) {
                    bl = true;
                    this.jreInfo.jreVersion().setStatus(JreDatum.STATUS_OK);
                } else {
                    object2 = this.getParameter("minimumjavaversion");
                    object = object2 == null ? "" : "  Your JRE version should be at least " + (String)object2 + ".";
                    this.jreInfo.jreVersion().setStatus(JreDatum.STATUS_ERROR, "Your JRE version isn't sufficient to run the Packet Tracer Skills Assessment Player." + (String)object);
                    if (this.stopOnJreVersionError()) {
                        return;
                    }
                }
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
                bl2 = false;
                this.jreInfo.jreVersion().setValueUnavailable();
            }
            if (bl2 && this.checkSecurityAccess()) {
                this.jreInfo.securityAccess().setValueOkay("Yes");
            } else {
                bl2 = false;
                this.jreInfo.securityAccess().setValueError("No", "You didn't accept the signed jar, so it doesn't have sufficient security access to run completely.  You must close all of your browsers, return to this page, and when presented with the dialog asking about signed applet privileges, you must accept, or select \"Yes\", to give this program the security access it needs to succeed.");
                if (this.stopOnNoSecurityAccessError()) {
                    return;
                }
            }
            try {
                if (this.checkBrowserName()) {
                    bl3 = true;
                    this.jreInfo.browserName().setStatus(JreDatum.STATUS_OK);
                } else {
                    object2 = this.getParameter("disallowedBrowserNames");
                    object = "  Your browser can't be any one of the following: " + (String)object2 + ".";
                    this.jreInfo.browserName().setStatus(JreDatum.STATUS_ERROR, "Your browser can't be used to take a Cisco Packet Tracer Skills Assessment." + (String)object);
                    if (this.stopOnBrowserNameError()) {
                        return;
                    }
                }
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
            if (bl2) {
                try {
                    object2 = "";
                    if (Utilities.isLinux()) {
                        Utilities.logPrintln("??? Utilities.isLinux() = " + Utilities.isLinux());
                        object2 = "linux";
                    } else if (Utilities.isWindows()) {
                        Utilities.logPrintln("??? Utilities.isWindows() = " + Utilities.isWindows());
                        object2 = "windows";
                    }
                    Utilities.logPrintln("... parameterPrefix = " + (String)object2);
                    object = (String)object2 + "ptenvironmentvariables";
                    string5 = this.getParameter((String)object);
                    String string7 = (String)object2 + "ptdirectories";
                    string6 = this.getParameter(string7);
                    Utilities.logPrintln("... envVarParameterName = " + (String)object);
                    Utilities.logPrintln("... envVarParameterString = " + string5);
                    Utilities.logPrintln("... specificDirParameterName = " + string7);
                    Utilities.logPrintln("... specificDirParameterString = " + string6);
                    if (Utilities.isWindows()) {
                        Utilities.logPrintln("??? Utilities.isWindows() = " + Utilities.isWindows());
                        if (string5 == null || string5.length() == 0) {
                            Utilities.logPrintln("??? envVarParameterString == null = " + (string5 == null));
                            Utilities.logPrintln("??? envVarParameterString.length() == 0 = " + (string5.length() == 0));
                            string5 = "PT6HOME,PT5HOME,PT_LAUNCH_DIR,PTDIR";
                            Utilities.logPrintln("... envVarParameterString = " + string5);
                        }
                        if (string6 == null || string6.length() == 0) {
                            Utilities.logPrintln("??? specificDirParameterString == null = " + (string6 == null));
                            Utilities.logPrintln("??? specificDirParameterString.length() == 0 = " + (string6.length() == 0));
                            string6 = "C:\\Program Files\\Packet Tracer 6.0,C:\\Program Files (x86)\\Packet Tracer 6.0,C:\\Program Files\\Packet Tracer 5.3.3,C:\\Program Files (x86)\\Packet Tracer 5.3.3,C:\\Program Files\\Packet Tracer 5.3.2,C:\\Program Files (x86)\\Packet Tracer 5.3.2";
                            Utilities.logPrintln("... specificDirParameterString = " + string6);
                        }
                    }
                    this.initializeLocator(string5, string6);
                }
                catch (Throwable throwable) {
                    Utilities.checkSwallow(throwable);
                    Utilities.logPrintln("Error while locating Packet Tracer installation directory:\n" + Utilities.toString(throwable));
                }
            }
            file.mkdirs();
            file2 = this.checkAndDownloadIfPossible(uRL, n, string3, file, file);
            Utilities.logPrintln("... skeletonFile = " + file2);
            if (file2 != null && file2.exists()) {
                this.jreInfo.skeletonSize().setValueInformational(String.valueOf(file2.length()));
            } else {
                this.jreInfo.skeletonSize().setValueError("N/A", "This required file was unable to be downloaded from the assessment server.");
            }
            if (this.ptHome != null) {
                this.jreInfo.ptDirectory().setValueOkay(this.ptHome.getCanonicalPath());
                file3 = this.checkAndDownloadIfPossible(uRL, n, string2, file, file);
                Utilities.logPrintln("... rawFile = " + file3);
            } else {
                Utilities.logPrintln("??? ptHome == null = " + (this.ptHome == null));
                this.jreInfo.ptDirectory().setValueError("Not found", "Your current environment variables don't allow us to find a candidate Packet Tracer installation directory.  You may identify the proper Packet Tracer installation directory by setting the value of one of these operating system environment variables: " + string5 + "; or by adding Packet Tracer's \"bin\" subdirectory to your PATH environment variable.");
                if (this.stopOnNoPtHomeError()) {
                    return;
                }
            }
            if (file3 != null && file3.exists()) {
                this.jreInfo.ptaFileDate().setValueOkay(new Date(file3.lastModified()).toString());
                this.jreInfo.ptaSize().setValueOkay(String.valueOf(file3.length()));
                try {
                    jarFile = new JarFile(file3);
                    Utilities.logPrintln("... jarFile = " + jarFile);
                }
                catch (Throwable throwable) {
                    Utilities.checkSwallow(throwable);
                }
            } else {
                Utilities.logPrintln("??? rawFile != null = " + (file3 != null));
                this.jreInfo.ptaFileDate().setValueUnavailable();
                this.jreInfo.ptaSize().setValueUnavailable();
                this.jreInfo.missingPtaJarFile().setValue("Missing", JreDatum.STATUS_ERROR, string2 + " can't be downloaded into a temporary directory.");
                if (this.stopOnNoRawFileError(string2)) {
                    return;
                }
            }
            if (jarFile != null) {
                this.jreInfo.missingPtaJarFile().setValueOkay("Yes");
            } else {
                if (file3 != null && file3.exists()) {
                    this.jreInfo.missingPtaJarFile().setValue("Invalid", JreDatum.STATUS_ERROR, string2 + " has an invalid format, or there is a configuration problem that prevents it from being loaded.");
                }
                if (this.stopOnNoJarFileError(string2)) {
                    return;
                }
            }
            if (string != null && string.trim().length() > 0 && (object2 = this.checkAndDownloadIfPossible(uRL, n, string, file, file)) != null) {
                try {
                    object = new JarFile((File)object2);
                    arrayList.add(object);
                }
                catch (Throwable throwable) {
                    Utilities.checkSwallow(throwable);
                }
            }
            this.jreInfo.missingPatchFiles().setValueOkay("Yes");
            if (bl && bl2 && file2 != null && file2.exists() && jarFile != null) {
                try {
                    this.loadClasses(file2, arrayList, jarFile, string4);
                }
                catch (Throwable throwable) {
                    Utilities.checkSwallow(throwable);
                    if (!this.stopOnJarLoadingError(throwable)) break block45;
                    return;
                }
            }
        }
        if (this.worker != null) {
            this.jreInfo.ptaBuild().setValueInformational(this.worker.getBuildVersion());
            this.jreInfo.ptaLoadDate().setValueInformational(this.worker.getLoadDate().toString());
            Utilities.logPrintln(">>> worker.setApplet()");
            this.worker.setApplet(this);
            Utilities.logPrintln(">>> worker.instanceCreation()");
            this.worker.instanceCreation();
            this.worker.init();
        } else {
            this.jreInfo.ptaBuild().setValueUnavailable();
            this.jreInfo.ptaLoadDate().setValueUnavailable();
            if (this.stopOnNoWorkerError()) {
                return;
            }
        }
    }

    protected void ptClearError() {
    }

    protected void ptDebug(String string) {
        this.callJavascript("error", "Information", string);
    }

    protected void ptLoadingStatus(int n, int n2, int n3) {
    }

    protected void ptSetStatus(String string) {
    }

    protected void ptThrowError(String string) {
        this.callJavascript("error", "PTMO Player Error", string);
    }

    protected void ptUpdateRender() {
    }

    protected static Map initializeDefaults() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("allowedjavaversions", "1.5;1.6;1.7");
        hashMap.put("allowedptversions", "5.3.2;5.3.3;6.");
        hashMap.put("autosaveintervalinmilliseconds", "300000");
        hashMap.put("backgroundcolor", "FFFFFF");
        hashMap.put("disallowedbrowsernames", "opera");
        hashMap.put("disallowedptversions", "");
        hashMap.put("linuxptdirectories", "/opt/pt");
        hashMap.put("linuxptenvironmentvariables", "PT6HOME,PT5HOME,PT_LAUNCH_DIR,PTDIR");
        hashMap.put("maxpkaloadtime", "300");
        hashMap.put("maxsessionpiecesize", "50000");
        hashMap.put("minimumjavaversion", "1.5");
        hashMap.put("minimumptversion", "5.3.2");
        hashMap.put("mode", "ravenna");
        hashMap.put("numberofdownloadtries", "5");
        hashMap.put("ptaplayerauthentication", "ptaplayer.pta");
        hashMap.put("ptaplayerfeatures", "autodownload,detailedlog,presubmitstatecheck,savebuffer");
        hashMap.put("ptaplayerlocation", "extensions/ptaplayer");
        hashMap.put("windowsptdirectories", "C:\\Program Files\\Packet Tracer 6.0,C:\\Program Files (x86)\\Packet Tracer 6.0,C:\\Program Files\\Packet Tracer 5.3.3,C:\\Program Files (x86)\\Packet Tracer 5.3.3,C:\\Program Files\\Packet Tracer 5.3.2,C:\\Program Files (x86)\\Packet Tracer 5.3.2");
        hashMap.put("windowsptenvironmentvariables", "PT6HOME,PT5HOME,PT_LAUNCH_DIR,PTDIR");
        hashMap.put("workerclass", "panther.pep.PtsiWorker");
        return hashMap;
    }
}

